#ifndef ATrie_HPP
#define ATrie_HPP

#include "Trie.hpp"
#include "iom.hpp"
#include <fstream>
#include <set>
#include <vector>
#include <cstdio>
using namespace std;


class ATrie
{
public:

   ATrie( const countertype counter_of_emptyset ):
      main_trie(counter_of_emptyset){}
   
   /// Insert the frequent items and their counters into the trie;
   void insert_frequent_items(const vector<countertype>& counters );
   
   void candidate_generation( const itemtype& frequent_size,
			      iom& iom );

   /// Increases the counter of those candidates that are contained 
   /// by the given basket.
   void find_candidate( const vector<itemtype>& basket, 
			const itemtype candidate_size, 
			const countertype counter=1 );

   /// Deletes unfrequent itemsets.
   void delete_infrequent( const double min_occurrence, 
			   const itemtype candidate_size );


   /// Returns true if trie is not empty
   bool is_there_any_candidate() const
   {
      return !main_trie.edgevector.empty();
   }

   ~ATrie(){}

protected:

   /// Decides if all subset of an itemset is contained in the ATrie
   bool is_all_subset_frequent( const set<itemtype>& maybe_candidate ) const;

   /// Generates candidate of size two
   void candidate_generation_two();

   /// Generates candidate of size more than two
   void candidate_generation_assist( 
      Trie* trie, 
      set<itemtype>& maybe_candidate, 
      iom& iom);

   /// Increases the counter for those itempairs that are in the given basket.
   void find_candidate_two( const vector<itemtype>& basket, 
			    const countertype counter=1 );

   /// Deletes the Tries that represent infrequent itemsets of size 2.
   void delete_infrequent_two( const double min_occurrence );

private:
   // No private methods

public:
   // No public members

protected:
   /// Trie to store the candidates.
   Trie main_trie;

   vector< vector<countertype> > temp_counter_array;
};

#endif
